/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ByteUtilities;

public class CmdExtendedError {
    private byte[] m_errorData;
    private static final int LENGTH_SIZE = 2;
    private static final int MODIFIER_SIZE = 2;
    private static final int ERROR_CODE_OFFSET = 2;
    private static final int ERROR_CODE_SIZE = 4;
    private static final int ERROR_PARMS_OFFSET = 6;
    private static final int BOUNDARY = 4;

    public CmdExtendedError() {
        this.m_errorData = new byte[6];
    }

    public CmdExtendedError(byte[] byArray) {
        this.setErrorData(byArray);
    }

    public final long extractErrorCode() {
        long l = 0L;
        long l2 = -1L;
        for (int i = 0; i < 4; ++i) {
            l |= (long)(this.m_errorData[i + 2] << (3 - i) * 8) & l2 >>> 32 + i * 8;
        }
        return l;
    }

    public final int extractModifier() {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < 2; ++i) {
            n |= this.m_errorData[i] << (1 - i) * 8 & n2 >>> 16 + i * 8;
        }
        return n;
    }

    public final byte[] getError() {
        int n = 2 + this.m_errorData.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> (1 - i) * 8 & 0xFF);
        }
        byArray = ByteUtilities.byteCopy(byArray, 2, this.m_errorData, 0, this.m_errorData.length);
        return byArray;
    }

    public final byte[] getErrorData() {
        return this.m_errorData;
    }

    public final byte[] getErrorParms() {
        return ByteUtilities.byteCopy(new byte[0], 0, this.m_errorData, 6, this.m_errorData.length - 2 - 4);
    }

    public final int getLength() {
        return this.m_errorData.length + 2;
    }

    public final void setErrorCode(long l) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(l >> (3 - i) * 8 & 0xFFL);
        }
        this.m_errorData = ByteUtilities.byteCopy(this.m_errorData, 2, byArray, 0, 4);
    }

    public final void setErrorData(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.m_errorData = byArray.length < 6 ? ByteUtilities.byteCopy(new byte[6], 0, byArray, 0, byArray.length) : (byte[])byArray.clone();
        int n = (this.m_errorData.length - 2) % 4;
        if (n > 0) {
            this.m_errorData = ByteUtilities.byteCat(this.m_errorData, new byte[n]);
        }
    }

    public final void setErrorParms(byte[] byArray) {
        this.m_errorData = ByteUtilities.byteCopyAndTrim(this.m_errorData, 6, byArray, 0, byArray.length);
        int n = byArray.length % 4;
        if (n > 0) {
            this.m_errorData = ByteUtilities.byteCat(this.m_errorData, new byte[n]);
        }
    }

    public final void setModifier(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> (1 - i) * 8 & 0xFF);
        }
        this.m_errorData = ByteUtilities.byteCopy(this.m_errorData, 0, byArray, 0, 2);
    }
}

